//+------------------------------------------------------------------+
//|                                                     Trigger Line |
//|                             Copyright  2005 dwt5 and adoleh2000 |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005 dwt5 and adoleh2000 "
#property link "http://www.metaquotes.net/"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 4 
//----  
#property indicator_color1 Blue 
#property indicator_color2 Blue
#property indicator_color3 Red 
#property indicator_color4 Red 
//----    +-------
extern int Rperiod = 15;
extern int LSMA_Period = 5;
//---- ------------------------------------+
//----  
double Ind_Buffer1[];
double Ind_Buffer2[];
double Ind_Buffer3[];
double Ind_Buffer4[];
//+------------------------------------------------------------------+
//| Trigger Line initialization function                             |
//+------------------------------------------------------------------+
int init()
{
//----   
SetIndexStyle(0,DRAW_LINE);
SetIndexStyle(1,DRAW_LINE);
SetIndexStyle(2,DRAW_LINE);
SetIndexStyle(3,DRAW_LINE);
//---- 4     
SetIndexBuffer(0,Ind_Buffer1);
SetIndexBuffer(1,Ind_Buffer2);
SetIndexBuffer(2,Ind_Buffer3);
SetIndexBuffer(3,Ind_Buffer4);
//----   ,      
SetIndexEmptyValue(0,0.0);
SetIndexEmptyValue(1,0.0);
//----        
IndicatorShortName("Trigger Line");
//----   ,       
SetIndexDrawBegin(0,2*Rperiod+6); 
SetIndexDrawBegin(1,2*Rperiod+6); 
//----    (    )      
IndicatorDigits(Digits);  
//----  
return(0);
}
//+------------------------------------------------------------------+
//| Trigger Line iteration function                                  |
//+------------------------------------------------------------------+
int start()
{ 
double Vel0,Vel1,LSMA,sum;
//----+        
int bar,limit,MaxBar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar = Bars-2*Rperiod-6;
//----     ,         
limit=Bars-counted_bars-1;
//----  
if(limit>=MaxBar)
  {
    limit=MaxBar;
    for(bar = Bars-1; bar >= MaxBar; bar--) 
      {
        Ind_Buffer1[bar] = 0; 
        Ind_Buffer2[bar] = 0; 
        Ind_Buffer3[bar] = 0; 
        Ind_Buffer4[bar] = 0; 
      }
  }
//----   ר 
for(bar = limit; bar >= 0; bar--) 
  { 
    sum = 0; 
    for(int iii = Rperiod; iii >= 1 ; iii--) sum+= ( iii - (Rperiod + 1.0)/3)*Close[bar+Rperiod-iii]; 
    //----
    Vel0 = sum*6/(Rperiod*(Rperiod+1.0)); 
    Vel1 = Ind_Buffer1[bar+1];
    LSMA = Vel0 + (Vel0-Vel1)* 2/(LSMA_Period+1);
    //----
    Ind_Buffer1[bar] = Vel0; 
    Ind_Buffer2[bar] = LSMA; 
    Ind_Buffer3[bar] = Vel0; 
    Ind_Buffer4[bar] = LSMA; 
    //----
    if (Vel0 < LSMA)
     {
      Ind_Buffer4[bar] = EMPTY_VALUE;
      Ind_Buffer3[bar] = EMPTY_VALUE;
     } 
  }
//----   
return(0);
}
//+---------------------------------------------------+

